<?php $pageTitle = 'Dashboard'; ?>
<?php require_once 'includes/header.php'; ?>

<?php
$services = $pdo->query("SELECT COUNT(*) FROM services")->fetchColumn();
$portfolio = $pdo->query("SELECT COUNT(*) FROM portfolio")->fetchColumn();
$messages = $pdo->query("SELECT COUNT(*) FROM messages")->fetchColumn();
$unread = $pdo->query("SELECT COUNT(*) FROM messages WHERE is_read = 0")->fetchColumn();
?>

<div class="stat-grid">
    <div class="stat-card">
        <div class="icon"><i class="fas fa-cogs"></i></div>
        <div class="label">Hizmetler</div>
        <div class="value"><?= $services ?></div>
    </div>
    <div class="stat-card">
        <div class="icon"><i class="fas fa-briefcase"></i></div>
        <div class="label">Portföy</div>
        <div class="value"><?= $portfolio ?></div>
    </div>
    <div class="stat-card">
        <div class="icon"><i class="fas fa-envelope"></i></div>
        <div class="label">Toplam Mesaj</div>
        <div class="value"><?= $messages ?></div>
    </div>
    <div class="stat-card">
        <div class="icon"><i class="fas fa-envelope-open"></i></div>
        <div class="label">Okunmamış</div>
        <div class="value"><?= $unread ?></div>
    </div>
</div>

<h2 style="margin-bottom:15px;">Son Mesajlar</h2>
<div class="table-wrap">
    <table>
        <thead><tr><th>Ad</th><th>E-posta</th><th>Konu</th><th>Tarih</th><th>Durum</th></tr></thead>
        <tbody>
        <?php
        $stmt = $pdo->query("SELECT * FROM messages ORDER BY created_at DESC LIMIT 5");
        while ($m = $stmt->fetch()):
        ?>
        <tr>
            <td><?= htmlspecialchars($m['name']) ?></td>
            <td><?= htmlspecialchars($m['email']) ?></td>
            <td><?= htmlspecialchars($m['subject']) ?></td>
            <td><?= $m['created_at'] ?></td>
            <td><?= $m['is_read'] ? '<span class="badge badge-green">Okundu</span>' : '<span class="badge badge-red">Yeni</span>' ?></td>
        </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>
