<?php $pageTitle = 'Yorumlar'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
if (isset($_GET['delete']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("DELETE FROM testimonials WHERE id = ?")->execute([$_GET['delete']]);
    header('Location: testimonials.php?msg=deleted'); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $data = [
        trim($_POST['client_name']),
        trim($_POST['client_title']),
        trim($_POST['comment']),
        intval($_POST['rating']),
        isset($_POST['is_active']) ? 1 : 0,
    ];
    if (!empty($_POST['id'])) {
        $data[] = $_POST['id'];
        $pdo->prepare("UPDATE testimonials SET client_name=?, client_title=?, comment=?, rating=?, is_active=? WHERE id=?")->execute($data);
    } else {
        $pdo->prepare("INSERT INTO testimonials (client_name, client_title, comment, rating, is_active) VALUES (?,?,?,?,?)")->execute($data);
    }
    header('Location: testimonials.php?msg=saved'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM testimonials WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch();
}
?>

<?php if (isset($_GET['msg'])): ?>
    <div class="alert alert-success"><?= $_GET['msg'] === 'saved' ? 'Kaydedildi.' : 'Silindi.' ?></div>
<?php endif; ?>

<div class="form-card">
    <h3 style="margin-bottom:15px;"><?= $edit ? 'Düzenle' : 'Yeni Yorum' ?></h3>
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
        <?php if ($edit): ?><input type="hidden" name="id" value="<?= $edit['id'] ?>"><?php endif; ?>
        <div class="form-row">
            <div class="form-group"><label>Müşteri Adı</label><input type="text" name="client_name" value="<?= htmlspecialchars($edit['client_name'] ?? '') ?>" required></div>
            <div class="form-group"><label>Ünvan</label><input type="text" name="client_title" value="<?= htmlspecialchars($edit['client_title'] ?? '') ?>"></div>
        </div>
        <div class="form-group"><label>Yorum</label><textarea name="comment" required><?= htmlspecialchars($edit['comment'] ?? '') ?></textarea></div>
        <div class="form-row">
            <div class="form-group"><label>Puan (1-5)</label><select name="rating">
                <?php for ($i = 5; $i >= 1; $i--): ?>
                    <option value="<?= $i ?>" <?= ($edit['rating'] ?? 5) == $i ? 'selected' : '' ?>><?= $i ?></option>
                <?php endfor; ?>
            </select></div>
            <div class="form-group"><label><input type="checkbox" name="is_active" <?= ($edit['is_active'] ?? 1) ? 'checked' : '' ?>> Aktif</label></div>
        </div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
        <?php if ($edit): ?><a href="testimonials.php" class="btn btn-secondary">İptal</a><?php endif; ?>
    </form>
</div>

<div class="table-wrap">
    <table>
        <thead><tr><th>Müşteri</th><th>Yorum</th><th>Puan</th><th>Durum</th><th>İşlem</th></tr></thead>
        <tbody>
        <?php foreach ($pdo->query("SELECT * FROM testimonials ORDER BY created_at DESC") as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['client_name']) ?></td>
            <td><?= htmlspecialchars(mb_substr($row['comment'], 0, 60)) ?>...</td>
            <td><?= $row['rating'] ?>/5</td>
            <td><?= $row['is_active'] ? '<span class="badge badge-green">Aktif</span>' : '<span class="badge badge-red">Pasif</span>' ?></td>
            <td class="actions">
                <a href="testimonials.php?edit=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Düzenle</a>
                <a href="testimonials.php?delete=<?= $row['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>
