<?php $pageTitle = 'Hizmetler'; ?>
<?php require_once 'includes/header.php'; ?>

<section class="section">
    <div class="container">
        <div class="section-title">
            <h2>Hizmetlerimiz</h2>
            <p>Geniş yelpazede yazılım hizmetleri sunuyoruz</p>
        </div>
        <div class="grid-3">
            <?php
            $stmt = $pdo->query("SELECT * FROM services WHERE is_active = 1 ORDER BY sort_order");
            while ($s = $stmt->fetch()):
            ?>
            <div class="card">
                <div class="icon"><i class="<?= htmlspecialchars($s['icon']) ?>"></i></div>
                <h3><?= htmlspecialchars($s['title']) ?></h3>
                <p><?= htmlspecialchars($s['description']) ?></p>
                <?php if ($s['price'] > 0): ?>
                    <p style="margin-top:15px;font-size:1.3rem;font-weight:700;color:#2563eb;">
                        <?= number_format($s['price'], 0, ',', '.') ?> ₺
                    </p>
                <?php endif; ?>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<section class="section section-light">
    <div class="container">
        <div class="section-title">
            <h2>Fiyatlandırma</h2>
            <p>İhtiyacınıza uygun paketi seçin</p>
        </div>
        <div class="pricing-grid">
            <?php
            $stmt = $pdo->query("SELECT * FROM pricing_plans ORDER BY sort_order");
            while ($p = $stmt->fetch()):
                $features = json_decode($p['features'], true) ?: [];
            ?>
            <div class="pricing-card <?= $p['is_featured'] ? 'featured' : '' ?>">
                <?php if ($p['is_featured']): ?><span class="badge">Popüler</span><?php endif; ?>
                <h3><?= htmlspecialchars($p['name']) ?></h3>
                <div class="price"><?= number_format($p['price'], 0, ',', '.') ?> ₺</div>
                <div class="period">/ <?= htmlspecialchars($p['period']) ?></div>
                <ul>
                    <?php foreach ($features as $f): ?>
                        <li><i class="fas fa-check"></i> <?= htmlspecialchars($f) ?></li>
                    <?php endforeach; ?>
                </ul>
                <a href="/yazilim-sitesi/iletisim.php" class="btn btn-blue">Teklif Alın</a>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
