<?php
session_start();
$pageTitle = 'İletişim';
require_once 'includes/header.php';

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token'])) {
        $error = 'Geçersiz istek.';
    } else {
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $subject = trim($_POST['subject'] ?? '');
        $message = trim($_POST['message'] ?? '');

        if ($name === '' || $email === '' || $message === '') {
            $error = 'Ad, e-posta ve mesaj alanları zorunludur.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'Geçerli bir e-posta adresi girin.';
        } else {
            $stmt = $pdo->prepare("INSERT INTO messages (name, email, phone, subject, message) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$name, $email, $phone, $subject, $message]);
            $success = 'Mesajınız başarıyla gönderildi. En kısa sürede dönüş yapacağız.';
        }
    }
}

$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>

<section class="section">
    <div class="container">
        <div class="section-title">
            <h2>İletişim</h2>
            <p>Bizimle iletişime geçin</p>
        </div>

        <?php if ($success): ?><div class="alert alert-success"><?= htmlspecialchars($success) ?></div><?php endif; ?>
        <?php if ($error): ?><div class="alert alert-error"><?= htmlspecialchars($error) ?></div><?php endif; ?>

        <div class="contact-grid">
            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                <div class="form-group">
                    <label>Adınız *</label>
                    <input type="text" name="name" required>
                </div>
                <div class="form-group">
                    <label>E-posta *</label>
                    <input type="email" name="email" required>
                </div>
                <div class="form-group">
                    <label>Telefon</label>
                    <input type="tel" name="phone">
                </div>
                <div class="form-group">
                    <label>Konu</label>
                    <input type="text" name="subject">
                </div>
                <div class="form-group">
                    <label>Mesajınız *</label>
                    <textarea name="message" required></textarea>
                </div>
                <button type="submit" class="btn btn-blue">Gönder</button>
            </form>
            <div class="contact-info-box">
                <h3>İletişim Bilgileri</h3>
                <div class="contact-info-item">
                    <i class="fas fa-phone"></i>
                    <span><?= htmlspecialchars($settings['phone'] ?? '') ?></span>
                </div>
                <div class="contact-info-item">
                    <i class="fas fa-envelope"></i>
                    <span><?= htmlspecialchars($settings['email'] ?? '') ?></span>
                </div>
                <div class="contact-info-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <span><?= htmlspecialchars($settings['address'] ?? '') ?></span>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
