CREATE DATABASE IF NOT EXISTS yazilim_sitesi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE yazilim_sitesi;

CREATE TABLE admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE services (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(200) NOT NULL,
    description TEXT,
    icon VARCHAR(50) DEFAULT 'fas fa-code',
    price DECIMAL(10,2) DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE pricing_plans (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    period VARCHAR(50) DEFAULT 'ay',
    features JSON,
    is_featured TINYINT(1) DEFAULT 0,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE portfolio (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(200) NOT NULL,
    description TEXT,
    image VARCHAR(500),
    client_name VARCHAR(100),
    project_url VARCHAR(500),
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE testimonials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_name VARCHAR(100) NOT NULL,
    client_title VARCHAR(200),
    comment TEXT NOT NULL,
    rating TINYINT DEFAULT 5,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(200) NOT NULL,
    phone VARCHAR(30),
    subject VARCHAR(300),
    message TEXT NOT NULL,
    is_read TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    `key` VARCHAR(100) NOT NULL UNIQUE,
    value TEXT
);

-- Varsayılan admin (şifre: admin123)
-- Şifre hash'i setup.php tarafından oluşturulur (admin123)
-- Önce bu SQL'i çalıştırın, sonra tarayıcıda setup.php'yi açın.
INSERT INTO admins (username, password) VALUES ('admin', 'SETUP_REQUIRED');

-- Varsayılan ayarlar
INSERT INTO settings (`key`, value) VALUES
('site_name', 'TechSoft Yazılım'),
('site_description', 'Profesyonel Yazılım Çözümleri'),
('email', 'info@techsoft.com'),
('phone', '+90 555 123 4567'),
('address', 'İstanbul, Türkiye'),
('footer_text', '© 2026 TechSoft Yazılım. Tüm hakları saklıdır.');

-- Örnek hizmetler
INSERT INTO services (title, description, icon, price, sort_order) VALUES
('Web Geliştirme', 'Modern ve responsive web siteleri geliştiriyoruz. PHP, Laravel, React, Vue.js gibi güncel teknolojilerle çalışıyoruz.', 'fas fa-globe', 5000, 1),
('Mobil Uygulama', 'iOS ve Android platformları için native ve cross-platform mobil uygulamalar geliştiriyoruz.', 'fas fa-mobile-alt', 8000, 2),
('E-Ticaret Çözümleri', 'Özel e-ticaret siteleri ve entegrasyonları ile online satışlarınızı artırın.', 'fas fa-shopping-cart', 10000, 3),
('SEO & Dijital Pazarlama', 'Arama motorlarında üst sıralarda yer alın, dijital varlığınızı güçlendirin.', 'fas fa-chart-line', 3000, 4),
('Bulut Çözümleri', 'AWS, Azure ve Google Cloud üzerinde ölçeklenebilir altyapı kurulumu.', 'fas fa-cloud', 6000, 5),
('Teknik Destek', '7/24 teknik destek ve bakım hizmetleri ile sistemleriniz güvende.', 'fas fa-headset', 2000, 6);

-- Örnek fiyat paketleri
INSERT INTO pricing_plans (name, price, period, features, is_featured, sort_order) VALUES
('Başlangıç', 2500, 'ay', '["5 Sayfa Web Sitesi","Responsive Tasarım","SSL Sertifikası","1 Yıl Hosting","E-posta Desteği"]', 0, 1),
('Profesyonel', 5000, 'ay', '["15 Sayfa Web Sitesi","Responsive Tasarım","SSL Sertifikası","1 Yıl Hosting","SEO Optimizasyonu","7/24 Destek","Admin Paneli"]', 1, 2),
('Kurumsal', 10000, 'ay', '["Sınırsız Sayfa","Responsive Tasarım","SSL Sertifikası","1 Yıl Hosting","SEO Optimizasyonu","7/24 Öncelikli Destek","Admin Paneli","Özel Entegrasyonlar","API Geliştirme"]', 0, 3);

-- Örnek portföy
INSERT INTO portfolio (title, description, image, client_name, project_url) VALUES
('E-Ticaret Platformu', 'Büyük ölçekli bir e-ticaret platformu geliştirdik.', '', 'ABC Şirketi', '#'),
('Kurumsal Web Sitesi', 'Kurumsal kimliğe uygun modern web sitesi tasarımı.', '', 'XYZ Holding', '#'),
('Mobil Uygulama', 'iOS ve Android için sipariş takip uygulaması.', '', 'Lojistik Co.', '#');

-- Örnek yorumlar
INSERT INTO testimonials (client_name, client_title, comment, rating) VALUES
('Ahmet Yılmaz', 'CEO, ABC Şirketi', 'TechSoft ile çalışmak harikaydı. Projemizi zamanında ve beklentilerimizin üzerinde teslim ettiler.', 5),
('Ayşe Demir', 'CTO, XYZ Holding', 'Profesyonel ekip, kaliteli iş. Web sitemiz sayesinde online satışlarımız %200 arttı.', 5),
('Mehmet Kaya', 'Kurucu, StartupTR', 'Mobil uygulamamızı hayal ettiğimizden çok daha iyi geliştirdiler. Kesinlikle tavsiye ederim.', 4);
